// ESP32-C3 Button Option Selector
// GPIO2 → Option A
// GPIO3 → Option B
// GPIO4 → Option C
// GPIO5 → Option D

int buttons[] = {2, 3, 4, 5};
const char* labels[] = {"Option A", "Option B", "Option C", "Option D"};
int lastState[4];

void setup() {
  Serial.begin(115200);
  delay(500);
  Serial.println("\nESP32-C3 Option Button Test");
  Serial.println("Press any button (GPIO 2–5)...\n");

  for (int i = 0; i < 4; i++) {
    pinMode(buttons[i], INPUT_PULLUP);
    lastState[i] = HIGH; // not pressed
  }
}

void loop() {
  for (int i = 0; i < 4; i++) {
    int current = digitalRead(buttons[i]);

    // Detect new press (HIGH → LOW)
    if (current == LOW && lastState[i] == HIGH) {
      delay(10); // debounce
      if (digitalRead(buttons[i]) == LOW) {
        Serial.print(labels[i]);
        Serial.println(" pressed!");
        lastState[i] = LOW;
      }
    }

    // Update when released (no print)
    if (current == HIGH && lastState[i] == LOW) {
      lastState[i] = HIGH;
    }
  }
}

